/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import com.google.common.base.CaseFormat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import svenhjol.charm.world.item.ItemMoonstone;
import svenhjol.meson.Feature;
import svenhjol.meson.handler.RecipeHandler;
import svenhjol.meson.helper.DyeHelper;
import svenhjol.meson.helper.ItemHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.registry.ProxyRegistry;

public class Moonstone
extends Feature {
    public static ItemMoonstone moonstone;
    public static boolean showInformation;
    public static boolean glowOnOrigin;
    public static String recipeItem;

    @Override
    public String getDescription() {
        return "The moonstone helps you locate a specific block co-ordinate or aid axis alignment across dimensions.";
    }

    @Override
    public void configure() {
        super.configure();
        showInformation = this.propBoolean("Add coordinates to tooltip", "If true, adds co-ordinates and dimension to the moonstone tooltip.", true);
        glowOnOrigin = this.propBoolean("Add glow effect on origin", "If true, the moonstone will have the glow effect when player is standing on the origin X and Z co-ordinate.", true);
        recipeItem = this.propString("Central recipe item", "The item in the center of the moonstone recipe.", "minecraft:quartz");
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        moonstone = new ItemMoonstone();
        RecipeHandler.addShapedRecipe(ProxyRegistry.newStack(moonstone, 1, 0), " G ", "GQG", " G ", Character.valueOf('Q'), ItemHelper.getItemStackFromItemString(recipeItem), Character.valueOf('G'), Items.field_151114_aO);
        for (EnumDyeColor value : EnumDyeColor.values()) {
            int meta = value.func_176767_b();
            RecipeHandler.addShapelessRecipe(ProxyRegistry.newStack(moonstone, 1, meta), ProxyRegistry.newStack(moonstone, 1, 0), DyeHelper.oredicts[meta]);
        }
        RecipeHandler.addShapelessRecipe(ProxyRegistry.newStack(moonstone, 1, 0), "moonstone");
    }

    @Override
    public void init(FMLInitializationEvent event) {
        OreDictionary.registerOre((String)"moonstone", (ItemStack)new ItemStack((Item)moonstone, 1, Short.MAX_VALUE));
    }

    @SubscribeEvent
    public void onMoonstoneUse(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getEntityPlayer() != null && event.getEntityPlayer().func_184586_b(event.getHand()).func_77973_b() == moonstone) {
            World world = event.getWorld();
            EntityPlayer player = event.getEntityPlayer();
            EnumHand hand = event.getHand();
            ItemStack held = player.func_184586_b(hand);
            BlockPos pos = event.getPos();
            ItemStack item = new ItemStack((Item)moonstone, 1, held.func_77960_j());
            if (player.func_70093_af()) {
                ItemMoonstone.setStonePos(item, pos);
                ItemMoonstone.setStoneDim(item, world.field_73011_w.getDimension());
                item.func_151001_c(held.func_82833_r());
                player.func_184609_a(hand);
                PlayerHelper.setHeldItem(player, hand, item);
            } else {
                world.func_180495_p(pos).func_177228_b().forEach((p1, p2) -> {
                    if (p1.func_177699_b() != EnumDyeColor.class) {
                        return;
                    }
                    String color = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, p2.toString());
                    int meta = 15 - EnumDyeColor.valueOf((String)color).func_176767_b();
                    held.func_77964_b(meta);
                });
            }
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

